function [Act_Rate,ChanDelays,MaxAdcRext]=STM32F103_ADC_SETUP(skt,Pins,Rate,RES_VAL,SAMP_CONST)
%
%function [Act_Rate,ChanDelays,MaxAdcRext]=STM32F411_ADC_SETUP(skt,Pins,Rate,RES_VAL,SAMP_CONST)
%
%  Set up an STM32F103 board for data capture with peek poke
%  Note - Data is left allgined in a 16 bit word, i.e. full scale is approx 65535
%  to convert output to volts  vout = num_out *1.22 / channel17 output (calibrate using internal reference)
%
%  skt           : peek poke udp skt structure
%  Pins          : io port pin numbers - 0 to 7 - on PA0-7 8 & 9 on PB0 and PB1
%                  17  gives internal referenc = 1.21V; 18 gives Chip Temp
%                 [ 0; 1] gives 2 channel simultaneous mode
%                 [ 0 1; 3 4] gives 4 channel simultaneous mode 0 with 3 and 1 with 4
%  Rate          : per channel conversion rate
%  RES_VAL       : ADC Resolution - default is 12 bits
%     0 = 12 bit
%     1 = 10 bits
%     2 = 8 bits
%     3 = 6 bits
%
%  SAMP_CONST
%000: 1.5 cycles
%001: 7.5 cycles
%010: 13.5 cycles
%011: 28.5 cycles
%100: 41.5 cycles
%101: 55.5 cycles
%110: 71.5 cycles
%111: 239.5 cycles
%
%   Act_Rate       : Actual sample rate per channel frame achieved (Hz)
%   ChanDelays     : Vector of dhannel delays relative to 1st channel   (Secs)
%   MaxAdcRext     : Maximum allowable external resistance of inputs to allow adequate ADC settling
%
% [Act_Rate,ChanDelays,MaxAdcRext]=STM32F411_ADC_SETUP(skt,[0 2 3],10000)
%
% See Also STM32F411_ADC_PLOT.m STM32F411_ADC_CAL.m
% Modified from STM32F411_ADC_SETUP 20-07-2022
% Ian Stothers 4th March 2021  Version 0
% Ian Stothers 7th Feb 2023  Version 1
%   Turned on TVSREFE so you can get at reference and temp sensor
%   Fixed selection of analogue channels used for SPI ethernet
%   Fixed multichannel DMA issue
% To Do
% Single shot capture
% ADC Calibration
% some timer bitfield need unhardcoding - search debug


if (nargin<5)
  SAMP_CONST=0;
endif
if (nargin<4)
  RES_VAL=0;
endif

STM32F103_bitfields; % Get some bitfields

% Read Core Clock rate from registry
FT_Clock=udpget(skt,"SystemCoreClock");

%Configure the relevant gpio pins as analogue
LPins=Pins(find(Pins<8));
 if ((find(LPins==5)+find(LPins==6)+find(LPins==7))>0)
   error("Analog pins used for other functions selected - i.e pins 5 6 or 7");
 endif
if min(size(LPins>0))
 %Make sure peripheral clock is on
 Port='IOPA';
 udp_bit_set(skt,"RCC_APB2ENR",[Port "EN"]);
 for pin=LPins
  STM32F103_IO_Config(skt,"GPIOA",pin,0);
 end
endif


HPins=Pins(find(Pins>7));
HPins=HPins(find(HPins<10));
if (find(HPins<9)>0)
   error("Analog pins used for other functions selected - i.e pins 8");
endif

if min(size(HPins>0))
 %Make sure peripheral clock is on
 Port='IOPB';
 udp_bit_set(skt,"RCC_APB2ENR",[Port "EN"]);
 for pin=HPins-8
  STM32F103_IO_Config(skt,"GPIOB",pin,0);
 end
endif

size_pins=size(Pins);
if (size_pins(1)<2)
  DualMode=0;
  DMA_Size=1;
  DMA_Buff_Div=2;
else
  DualMode=1;
  DMA_Size=2;
  DMA_Buff_Div=4;
end

VRefPin=Pins(find(Pins==17));

Num_ADC_Chans=size_pins(2);

%Shut down peripherals
udpset(skt,"TIM3_PSC",0);                 % make sure timer stops quickly
udpset(skt,"TIM3_ARR",20000);             % make sure timer stops quickly
udpset(skt,"TIM3_CNT",100);               % make sure timer stops quickly
udp_bit_clear(skt,"DMA1_C1_CCR",EN);       % tell dma to stop
udp_bit_clear(skt,"ADC12_COMMON_CR2",ADON);       % tell ADC1 to stop
udp_bit_clear(skt,"TIM3_CR1",CEN);        % tell the timer to stop
udp_bit_clear(skt,"RCC_APB1ENR",TIM3EN);  % TIM3 clock is off
udp_bit_clear(skt,"RCC_APB2ENR",ADC1EN); % ADC1 clock is off

%Set up ADC1
udp_bit_set(skt,"RCC_APB2ENR",ADC1EN);   % ADC1 clock is on

% Clear the Status Reg
udpset(skt,"ADC12_COMMON_SR",0);
% ADC1_CR1
SMULT=1;
if (size_pins(2)==1)
SMULT=0;
end
ADC1_CR1_CLEAR =   AWDEN+ JAWDEN+ (DUALMOD*15)+(DISCNUM*7)+ JDISCEN + DISCEN + JAUTO + AWDSGL + SCAN + JEOCIE + AWDIE + EOCIE + (31* AWDCH);
ADC1_CR1_SET =  SCAN*SMULT + DUALMOD*6*DualMode;
udp_bit_clear(skt,"ADC12_COMMON_CR1",ADC1_CR1_CLEAR); % Clear bits
udp_bit_set(skt,"ADC12_COMMON_CR1",ADC1_CR1_SET); % Set Bits

% ADC1_CR2
ADC1_CR2_CLEAR = SWSTART+(EXTSEL*7) +  (JEXTSEL*15)+ ALIGN +  DMA + CONT+ ADON;
%ADC1_CR2_SET =  (EXTEN*1) + (EXTSEL*3)+ ALIGN*0 + DMA+DDS;
ADC1_CR2_SET =  EXTTRIG + (EXTSEL*4)+ ALIGN*1 + DMA + TSVREFE;
udp_bit_clear(skt,"ADC12_COMMON_CR2",ADC1_CR2_CLEAR);
udp_bit_set(skt,"ADC12_COMMON_CR2",ADC1_CR2_SET);
udp_bit_set(skt,"ADC12_COMMON_CR2",+ADON);

udp_bit_set(skt,"ADC12_COMMON_CR2",RSTCAL);
while (bitand(udpget(skt,"ADC12_COMMON_CR2"),CAL)>0); end
udp_bit_set(skt,"ADC12_COMMON_CR2",RSTCAL);
while (bitand(udpget(skt,"ADC12_COMMON_CR2"),CAL)>0); end



% ADC1_SMPR2
% Debug - needs fixup MaxAdcRext=((SampCycles(SAMP_CONST+1)-0.5)/((FT_Clock/(2+(2*(ADC_PR))))*7e-12*log(2^(12-(RES_VAL*2)+2))))-6000;
%if (MaxAdcRext<1000)
%  printf("Warning - ADC Rext must be below %f ohms\n",MaxAdcRext);
%endif
cv=sum(ADC_SMP2);
udp_bit_clear(skt,"ADC1_SMPR2",cv*7); % ADC sample time
udp_bit_set(skt,"ADC1_SMPR2",cv*SAMP_CONST); % ADC sample time set to 3 for all channel


% ADC1_SMPR1
cv=sum(ADC_SMP1);
udp_bit_clear(skt,"ADC1_SMPR1",cv*7); % ADC sample time
udp_bit_set(skt,"ADC1_SMPR1",cv*SAMP_CONST); % ADC sample time set to 3 for all channel


% MAX_ADC_RATE
ADCPRE_VAL=[2 4 6 8](1+floor(bitand(udpget(skt,'RCC_CFGR'),ADCPRE*3)/ADCPRE));
PPRE2_VAL=[1 1 1 1 2 4 8 16](1+floor(bitand(udpget(skt,'RCC_CFGR'),PPRE2*7)/PPRE2));
ADCCLK=FT_Clock/(ADCPRE_VAL*PPRE2_VAL);
MAX_ADC_RATE=ADCCLK/(ceil(SampCycles(SAMP_CONST+1)+14)*Num_ADC_Chans);
ChanDelays=((1:Num_ADC_Chans)-1)*ceil(SampCycles(SAMP_CONST+1)+14)/ADCCLK;
if (Rate>MAX_ADC_RATE)
   printf("Sample Rate %f too high - Rate limited to %f\n",Rate,MAX_ADC_RATE  );
   Rate=MAX_ADC_RATE;
endif
%ADC1_JOFRx
udp_bit_clear(skt,"ADC1_JOFR1",sum((2.^[0:11 ])));
udp_bit_clear(skt,"ADC1_JOFR2",sum((2.^[0:11 ])));
udp_bit_clear(skt,"ADC1_JOFR3",sum((2.^[0:11 ])));
udp_bit_clear(skt,"ADC1_JOFR4",sum((2.^[0:11 ])));

%ADC1_HTR
udp_bit_set(skt,"ADC1_HTR",sum((2.^[0:11 ])));

%ADC1_LTR
udp_bit_clear(skt,"ADC1_LTR",sum((2.^[0:11 ])));

PinP = zeros(1,16);
PinP(1:max(size(Pins(1,:))))=Pins(1,:);

%ADC1_SQR3
udp_bit_clear(skt,"ADC1_SQR3",(2.^30)-1);
udp_bit_set(skt,"ADC1_SQR3",sum((PinP(1:6)).*(32.^(0:5))));

%ADC1_SQR2
udp_bit_clear(skt,"ADC1_SQR2",(2.^30)-1);
udp_bit_set(skt,"ADC1_SQR2",sum((PinP(7:12)).*(32.^(0:5))));

%ADC1_SQR1
udp_bit_clear(skt,"ADC1_SQR1",15*SQR_L);   % Set the number of chamnnels to be converted debug - bitfild names
udp_bit_set(skt,"ADC1_SQR1",(Num_ADC_Chans-1)*SQR_L);
udp_bit_set(skt,"ADC1_SQR1",sum((PinP(13:16)).*(32.^(0:3))));
%ADC1_JSQR
udp_bit_clear(skt,"ADC1_JSQR",sum((2.^[0:21 ])));

if (DualMode==1)
 ADC1_CR1_CLEAR =   AWDEN+ JAWDEN+ (DUALMOD*15)+(DISCNUM*7)+ JDISCEN + DISCEN + JAUTO + AWDSGL + SCAN + JEOCIE + AWDIE + EOCIE + (31* AWDCH);
ADC1_CR1_SET =  SCAN*SMULT + DUALMOD*6*DualMode;
udp_bit_clear(skt,"ADC2_CR1",ADC1_CR1_CLEAR); % Clear bits
udp_bit_set(skt,"ADC2_CR1",ADC1_CR1_SET); % Set Bits

% ADC1_CR2
ADC1_CR2_CLEAR = SWSTART+(EXTSEL*7) +  (JEXTSEL*15)+ ALIGN +  DMA + CONT+ ADON;
%ADC1_CR2_SET =  (EXTEN*1) + (EXTSEL*3)+ ALIGN*0 + DMA+DDS;
ADC1_CR2_SET =  EXTTRIG + (EXTSEL*4)+ ALIGN*1 + DMA;
udp_bit_clear(skt,"ADC2_CR2",ADC1_CR2_CLEAR);
udp_bit_set(skt,"ADC2_CR2",ADC1_CR2_SET);
udp_bit_set(skt,"ADC2_CR2",+ADON);

udp_bit_set(skt,"ADC2_CR2",RSTCAL);
while (bitand(udpget(skt,"ADC2_CR2"),CAL)>0); end
udp_bit_set(skt,"ADC2_CR2",RSTCAL);
while (bitand(udpget(skt,"ADC2_CR2"),CAL)>0); end

 udp_bit_clear(skt,"ADC2_SMPR2",cv*7); % ADC sample time
 udp_bit_set(skt,"ADC2_SMPR2",cv*SAMP_CONST); % ADC sample time set to 3 for all channel

 udp_bit_clear(skt,"ADC2_SMPR1",cv*7); % ADC sample time
 udp_bit_set(skt,"ADC2_SMPR1",cv*SAMP_CONST); % ADC sample time set to 3 for all channel


 udp_bit_clear(skt,"ADC2_JOFR1",sum((2.^[0:11 ])));
 udp_bit_clear(skt,"ADC2_JOFR2",sum((2.^[0:11 ])));
 udp_bit_clear(skt,"ADC2_JOFR3",sum((2.^[0:11 ])));
 udp_bit_clear(skt,"ADC2_JOFR4",sum((2.^[0:11 ])));

 %ADC2_HTR
 udp_bit_set(skt,"ADC2_HTR",sum((2.^[0:11 ])));

 %ADC2_LTR
 udp_bit_clear(skt,"ADC2_LTR",sum((2.^[0:11 ])));

 PinP = zeros(1,16);
 PinP(1:max(size(Pins(2,:))))=Pins(2,:);

 %ADC2_SQR3
 udp_bit_clear(skt,"ADC2_SQR3",(2.^30)-1);
 udp_bit_set(skt,"ADC2_SQR3",sum((PinP(1:6)).*(32.^(0:5))));

 %ADC2_SQR2
 udp_bit_clear(skt,"ADC2_SQR2",(2.^30)-1);
 udp_bit_set(skt,"ADC2_SQR2",sum((PinP(7:12)).*(32.^(0:5))));

 %ADC2_SQR1
 udp_bit_clear(skt,"ADC2_SQR1",15*SQR_L);   % Set the number of chamnnels to be converted debug - bitfild names
 udp_bit_set(skt,"ADC2_SQR1",(Num_ADC_Chans-1)*SQR_L);
 udp_bit_set(skt,"ADC2_SQR1",sum((PinP(13:16)).*(32.^(0:3))));

 %ADC2_JSQR
 udp_bit_clear(skt,"ADC2_JSQR",sum((2.^[0:21 ])));
 udp_bit_set(skt,"ADC2_CR2",CAL);
while (bitand(udpget(skt,"ADC2_CR2"),CAL)>0); end
endif


%Set up DMA1 Channel1
%udp_bit_set(skt,"RCC_AHBENR",DMA1EN); % DMA clock is on
udp_bit_clear(skt,"DMA1_C1_CCR",EN);
DMA_CLEAR_VAL =sum([  PL*3  MSIZE*3 PSIZE*3 MINC PINC CIRC DIR TEIE  HTIE TCIE  EN]);
udp_bit_clear(skt,"DMA1_C1_CCR",DMA_CLEAR_VAL);
DMA_SET_VAL =sum([  PL*0  MSIZE*DMA_Size PSIZE*DMA_Size MINC  CIRC  ]);
udp_bit_set(skt,"DMA1_C1_CCR",DMA_SET_VAL);
udpset(skt,"DMA1_C1_CMAR",skt.ptr(skt_find_index(skt,"ADC_DMA_Buffer")));
udpset(skt,"DMA1_C1_CPAR",skt.ptr(skt_find_index(skt,"ADC1_DR")));
int2send=floor(skt.len(skt_find_index(skt,"ADC_DMA_Buffer"))/(DMA_Buff_Div*(Num_ADC_Chans)))*Num_ADC_Chans; % Debug

udpset(skt,"DMA1_C1_CNDTR",int2send);

%udpset(skt,"DMA1_C1_FCR",0); % Direct mode DMA- no FIFO

%Set up Timer 2 to drive ADC
udp_bit_set(skt,"RCC_APB1ENR",TIM3EN); % TIMER2 clock is on
udpset(skt,"TIM3_CR1",0);           %Clear TIM2_CR1
udpset(skt,"TIM3_CR2",0);           %Clear TIM2_CR1

udp_bit_set(skt,"TIM3_CR1",ARPE+URS);%configure TIM2_CR1
udpset(skt,"TIM3_CR2",2*MMS);%configure the timer event = reload

%PSC Prescaler and ARR = n+1 dividers

divid=FT_Clock/Rate;
t2_psc=3;%floor(divid/65536); debug
t2cnt=round(FT_Clock/((t2_psc+1)*Rate))-1;
Act_Rate=FT_Clock/((t2cnt+1)*(t2_psc+1));


udpset(skt,"TIM3_PSC",t2_psc);%configure the timer prescaler
udpset(skt,"TIM3_ARR",t2cnt);%configure the timer reload (period) register


% Let rip
udp_bit_set(skt,"DMA1_C1_CCR",EN);     % Tell DMA to go
udp_bit_set(skt,"TIM3_CR1",CEN);      % Tell TIM3 to go

udp_bit_set(skt,"TIM3_EGR",1);


